﻿'版权所有 (C) Microsoft Corporation。保留所有权利。

Imports System
Imports System.Configuration
Imports System.ServiceModel
Imports System.ServiceModel.PeerResolvers

Namespace Microsoft.ServiceModel.Samples
    ' 采用对等通道(多方通道)的多方聊天应用程序
    ' 聊天服务协定
    ' 通过对服务协定应用 [PeerBehavior] 属性，能从 IClientChannel 中检索 PeerNode。
    <ServiceContract([Namespace]:="http://Microsoft.ServiceModel.Samples", CallbackContract:=GetType(IChat))> _
    Public Interface IChat

        <OperationContract(IsOneWay:=True)> _
        Sub Join(ByVal member As String)
        <OperationContract(IsOneWay:=True)> _
        Sub Chat(ByVal member As String, ByVal msg As String)
        <OperationContract(IsOneWay:=True)> _
        Sub Leave(ByVal member As String)

    End Interface
    Public Interface IChatChannel
        Inherits IChat
        Inherits IClientChannel

    End Interface

End Namespace
